Scriptname nwsFollowerControllerScript extends Quest  Conditional

; actors --
Actor Property myPlayer  Auto  

; game properties --
GlobalVariable Property pPlayerFollowerCount Auto
Faction Property pDismissedFollower Auto
Faction Property pCurrentHireling Auto
Message Property  FollowerDismissMessage Auto
Message Property AnimalDismissMessage Auto
Message Property  FollowerDismissMessageWedding Auto
Message Property  FollowerDismissMessageCompanions Auto
Message Property  FollowerDismissMessageCompanionsMale Auto
Message Property  FollowerDismissMessageCompanionsFemale Auto
Message Property  FollowerDismissMessageWait Auto

GlobalVariable Property PlayerAnimalCount Auto

Message Property nwsCmdAll_MSG Auto
Message Property nwsCmdOne_MSG Auto
Message Property nwsCmdRange_MSG Auto
Message Property nwsCmdDist_MSG Auto
Message Property nwsCmdWait_MSG Auto
Spell Property nwsCommandAllSpell Auto

; external scripts
SetHirelingRehire Property HirelingRehireScript Auto
DialogueFollowerScript Property followerScript Auto

; used to capture vanilla actions: wait, follow, dismiss
ReferenceAlias Property speakerREF Auto
ReferenceAlias Property bladesREF Auto

; my variables
int slotsUsed = 10

GlobalVariable Property nwsFollowerCount Auto
int myFCount

GlobalVariable Property nwsAnimalCount Auto
int myACount

; import
GlobalVariable Property nwsImportCount Auto ; number of imported allies
Faction Property nwsFF_ImportFac Auto
; import features
Faction Property nwsFF_StealthFac Auto
Faction Property nwsFF_BoxFaction Auto ; indy sandbox faction
Faction Property nwsFF_WaitFaction Auto
Faction Property nwsFF_HelmFac Auto ; helmet faction


; settings factions --
Faction Property nwsFF_ComeHereFac Auto ; null

Faction Property nwsFF_NCRangeFac Auto
Faction Property nwsFF_RangeFac Auto
Faction Property nwsFF_RoleFac Auto
int Property nwsBladesCandidate Auto Conditional

; features --
Spell Property nwsPortAllAbility Auto
GlobalVariable Property nwsAllowSandbox Auto
GlobalVariable Property nwsAllowStealth Auto
GlobalVariable Property nwsBoxOnlyCity Auto
GlobalVariable Property nwsAllowWarp Auto
GlobalVariable Property nwsAllowSpeed Auto
GlobalVariable Property nwsBladeOpt Auto
GlobalVariable Property nwsWeapDraw Auto
Faction Property nwsFF_SpeedFac Auto

; sandboxing --
int Property nwsGroupRelax Auto Conditional 
float relaxCDTime
float baseRelaxTime = 7.0
bool isPlayerRelaxed = false

float warpCDTime
float baseWarpTime = 10.0

; general --
bool evalNPC = false
float timerTick = 1.0

int slotNumber ; description as string
int indexFound ; true index position

Faction Property nwsFF_EssFac Auto

; tutorials --

Message Property nwsTut_countMSG  Auto  
bool Property nwsTut_countShown Auto Conditional
bool Property nwsTut_helmShown Auto Conditional
; ---

FormList Property nwsFFequipForm Auto
ObjectReference Property nwsFFequipREF Auto

Quest Property DialogueFollower Auto
Quest Property nwsFollowerPack Auto

Spell Property nwsHealSelf Auto

GlobalVariable Property nwsRealCount Auto
nwsFollower_PlayerAlias Property playerAliasScript Auto ; double check this

; test for import
Faction Property CurrentFollowerFaction Auto
Faction Property PlayerFollowerFaction Auto
Faction Property WIFollowerCommentFaction Auto


Weapon Property AkaviriKatana Auto
Armor Property ArmorBladesBoots Auto
Armor Property ArmorBladesCuirass Auto
Armor Property ArmorBladesGauntlets Auto
Armor Property ArmorBladesHelmet Auto
Armor Property ArmorBladesShield Auto

; sandboxing --
Event OnUpdate()
	evalNPC = false
	SandboxFollowers()
	if evalNPC
		DoTaskAll(1)
	endif

	; if warp enabled
	if nwsAllowWarp.GetValue() == 1
		WarpCheckPlayer()
	endif

	RegisterForSingleUpdate(timerTick)
EndEvent

Function SandboxFollowers()
	bool relaxOnCD

	relaxCDTime = ( relaxCDTime - timerTick )
	relaxOnCD = relaxCDTime > 0

	bool inCombat = myPlayer.IsInCombat()
	bool sneaking = myPlayer.IsSneaking()
	bool sprinting = myPlayer.IsSprinting()
	bool running = myPlayer.IsRunning()
	bool hasWeapon = myPlayer.IsWeaponDrawn()
	bool isMounted = myPlayer.IsOnMount()
	bool notSitting = myPlayer.GetSitState() != 3

	if ( inCombat || sneaking || running || sprinting || hasWeapon || isMounted ) && notSitting
		if nwsGroupRelax == 1
			;debug.notification("follow player")
			nwsGroupRelax = 0
		endif
		if (isPlayerRelaxed == True)
			evalNPC = True
		endif
		relaxCDTime = baseRelaxTime
		isPlayerRelaxed = False
	else
		if relaxOnCD == False
			if nwsGroupRelax == 0
				nwsGroupRelax = 1
				;debug.notification("start sandbox")
			endif
		endif
		if (isPlayerRelaxed == False)
			evalNPC = True
		endif
		isPlayerRelaxed = True
	endif
EndFunction

Function WarpCheckPlayer()
	; split function to reduce script load
	warpCDTime += 1
	if warpCDTime >= baseWarpTime
		warpCDTime = 0
		;debug.notification("check warp")

		bool notCombat = !myPlayer.IsInCombat()
		bool notMounted = !myPlayer.IsOnMount()
		bool sprinting = myPlayer.IsSprinting()
		bool running = myPlayer.IsRunning()
		if (notCombat && notMounted) && (sprinting || running)
			; run actor warp check across all followers
			DoTaskAll(6)
		endif
	endif

EndFunction

Function WarpCheckActor(actor myActor)

	float isWaiting = myActor.GetActorValue("WaitingForPlayer")
	bool isFar = (myPlayer.GetDistance(myActor) > 4096.0)

	if (isFar && isWaiting == 0.0)
		;debug.notification("warping actor")
		FollowerPort(myActor)
	endif
EndFunction

; STARTUP Functions --
Function StartupCheck()
	; Add Player Spells
	if myPlayer.HasSpell(nwsPortAllAbility) == False
		myPlayer.AddSpell(nwsPortAllAbility)
	endif
	if myPlayer.HasSpell(nwsCommandAllSpell) == False
		myPlayer.AddSpell(nwsCommandAllSpell)
	endif

	; augment followers
	if nwsAllowSpeed.GetValue() == 1
		AugmentSpeedAll(1)
	endif

	; apply game settings
	Game.SetGameSettingFloat("fFollowSpaceBetweenFollowers", 16.0)
	Game.SetGameSettingFloat("iFriendHitCombatAllowed", 15.0)

	; experimental
	Game.SetGameSettingFloat("fCombatTeammateFollowRadiusBase", 16.0)
	Game.SetGameSettingFloat("fCombatTeammateFollowRadiusMin", 16.0)

	if nwsWeapDraw.GetValue() == 1
		Game.SetGameSettingFloat("fAIDistanceTeammateDrawWeapon", 0.0)
	endif

	;Game.SetGameSettingFloat("fDetectEventDistanceNPC", 1024.0)
EndFunction

; FOLLOWER FRAMEWORK Replacement Functions --

; Recuit Follower (replacement)
Function RecruitFollower(actor myActor)

	ReferenceAlias filledAlias = SearchAlias(myActor, 1)
	if filledAlias == None
		ReferenceAlias lookAlias = SearchAlias(myActor, 0) ; find empty slot
		if lookAlias

			lookAlias.ForceRefTo(myActor)
			string actName = myActor.GetBaseObject().GetName()
			debug.notification(actName + " added to Slot "+slotNumber)

			If myActor.GetRelationshipRank(Game.GetPlayer()) < 3 && myActor.GetRelationshipRank(Game.GetPlayer()) >= 0
				myActor.SetRelationshipRank(Game.GetPlayer(), 3)
			EndIf

			myActor.RemoveFromFaction(pDismissedFollower)
			myActor.SetPlayerTeammate()
			myActor.IgnoreFriendlyHits(true)

			GetFollowerCount() ; adjust follower count

			if !myActor.IsInFaction(nwsFF_RoleFac)
				SetFollowerRole(myActor, 0, 0)
			endif

			if nwsAllowSpeed.GetValue() == 1
				AugmentSpeed(myActor, 1)
			endif

			; test
			myActor.AddToFaction(CurrentFollowerFaction)
			myActor.AddToFaction(PlayerFollowerFaction)
			myActor.AddToFaction(WIFollowerCommentFaction)

			myActor.EvaluatePackage()

		else
			debug.notification("You have too many followers")
		endif
	endif

EndFunction

; Recruit Animal
; not yet multi-animal
Function RecruitAnimal(actor myActor)
	;debug.notification("recruiting animal")

	; attempt a block for stray animals
	ReferenceAlias filledAlias = SearchAlias(myActor, 1)
	if filledAlias == None
		ReferenceAlias lookAlias = SearchAlias(myActor, 0, 1) ; find empty slot
		if lookAlias

			lookAlias.ForceRefTo(myActor)

			string actName = myActor.GetBaseObject().GetName()
			debug.notification(actName + " added to Pet Slot "+slotNumber)

			myActor.SetRelationshipRank(Game.GetPlayer(), 3)
			myActor.SetAV("Lockpicking", 0)
			myActor.SetPlayerTeammate()
			myActor.IgnoreFriendlyHits(true)

			; adjust animal count
			GetFollowerCount()

			if nwsAllowSpeed.GetValue() == 1
				AugmentSpeed(myActor, 1)
			endif

			myActor.AddToFaction(CurrentFollowerFaction)
			myActor.AddToFaction(PlayerFollowerFaction)

			myActor.EvaluatePackage()
		else
			debug.notification("You have too many pets")
		endif
	endif

EndFunction

Function RemoveAnimal(actor myActor,  int iMessage = 0)
	if myActor.IsDead() == False
		;debug.notification("remove animal")

		myActor.StopCombatAlarm()
		myActor.SetActorValue("Variable04", 0)

		; needs to be replaced
		GetFollowerCount()

		myActor.SetPlayerTeammate(false)
		myActor.SetAV("WaitingForPlayer", 0)

		myActor.IgnoreFriendlyHits(false)

		myActor.RemoveFromFaction(CurrentFollowerFaction)
		myActor.RemoveFromFaction(PlayerFollowerFaction)

		referenceAlias lookAlias = SearchAlias(myActor, 1)
		if lookAlias
			if iMessage == 0
				string actName = myActor.GetBaseObject().GetName()
				debug.notification(actName + " has been dismissed")
			endif
			lookAlias.Clear()
		endif

		if iMessage != -1 ; not mass dismiss
			GetFollowerCount() ; adjust follower count
		endif

		myActor.EvaluatePackage()

	endif
EndFunction


; Remove Follower (replacement)
Function RemoveFollower(actor myActor, int iMessage = 0, int iSayLine = 1)

	if (myActor.IsDead()) == False && (!myActor.IsInFaction(pDismissedFollower))

		if myActor.IsInFaction(nwsFF_ImportFac)
			string actName = myActor.GetBaseObject().GetName()
			debug.notification(actName + " cannot be dismissed")
		else
			If iMessage == 1
				FollowerDismissMessageWedding.Show()
			ElseIf iMessage == 2
				FollowerDismissMessageCompanions.Show()
			ElseIf iMessage == 3
				FollowerDismissMessageCompanionsMale.Show()
			ElseIf iMessage == 4
				FollowerDismissMessageCompanionsFemale.Show()
			ElseIf iMessage == 5
				FollowerDismissMessageWait.Show()
			ElseIf iMessage != -1 && iMessage != 0
				;failsafe
				FollowerDismissMessage.Show()
			EndIf

			myActor.StopCombatAlarm()
			myActor.AddToFaction(pDismissedFollower)
			myActor.SetPlayerTeammate(false)
			myActor.RemoveFromFaction(pCurrentHireling)
			myActor.SetAV("WaitingForPlayer", 0)

			; TWEAKS go here --
			myActor.IgnoreFriendlyHits(false)

			; handle hirelings --
			HirelingRehireScript.DismissHireling(myActor.GetActorBase())

			If iSayLine == 1
				followerScript.iFollowerDismiss = 1
				myActor.EvaluatePackage()
				;Wait for follower to say line
				Utility.Wait(2)
			EndIf

			; remove from slots
			referenceAlias lookAlias = SearchAlias(myActor, 1)

			if lookAlias
				if iMessage == 0
					string actName = myActor.GetBaseObject().GetName()
					debug.notification(actName + " has been dismissed")
				endif
				lookAlias.Clear()
			endif
			followerScript.iFollowerDismiss = 0

			; remove augment speed
			AugmentSpeed(myActor, 0)

			; test
			myActor.RemoveFromFaction(CurrentFollowerFaction)
			myActor.RemoveFromFaction(PlayerFollowerFaction)
			myActor.RemoveFromFaction(WIFollowerCommentFaction)

			if iMessage != -1 ; not mass dismiss
				GetFollowerCount() ; adjust follower count
			endif
		endif
	endif
EndFunction

Function ToggleRealCount()
	if nwsRealCount.GetValue() == 0
		nwsRealCount.SetValue(1)
		playerAliasScript.CheckCount()
	else
		nwsRealCount.SetValue(0)
	endif
EndFunction 

; Follower Wait (replacement)
Function FollowerWaitHere(actor myActor, int notify=0, int doPerm=0)
	myActor.SetAv("WaitingForPlayer", 1)

	if doPerm
		myActor.AddToFaction(nwsFF_WaitFaction)
	endif

	bool InWaitFaction = myActor.IsInFaction(nwsFF_WaitFaction)

	if notify
		string actName = myActor.GetBaseObject().GetName()

		if InWaitFaction
			debug.notification(actName + " will wait here for you indefinitely")
		else
			debug.notification(actName + " will wait here for you")
		endif

	endif
	referenceAlias lookAlias = SearchAlias(myActor, 1)
	if lookAlias
		if InWaitFaction
			(lookAlias as FollowerAliasScript).UnRegisterForUpdateGameTime()
		else
			lookAlias.RegisterForUpdateGameTime(72)
		endif
	endif
EndFunction

; Follower Follow (replacement)
Function FollowerFollowMe(actor myActor, int notify=0)
	myActor.SetAv("WaitingForPlayer", 0)

	if myActor.IsInFaction(nwsFF_WaitFaction)
		myActor.RemoveFromFaction(nwsFF_WaitFaction)
	endif

	if notify
		string actName = myActor.GetBaseObject().GetName()
		debug.notification(actName + " is following you")
	endif
	;SetObjectiveDisplayed(10, abdisplayed = false)
EndFunction


; FOLLOWER FRAMEWORK Core Functions --

; Alias Crawler - 0 to find empty slot, 1 to match actor
; can pass Actor = None for empty slot search
; adding animal flag
ReferenceAlias Function SearchAlias(actor myActor, int myVal, int IsAnimal = 0)
	int index = (slotsUsed - 1) ; slots index
	bool stopLook = False
	actor follower
	ReferenceAlias checkAlias
	ReferenceAlias aliasFound = None

	int[] animSlots = new Int[5]
	animSlots[0] = 1
	animSlots[1] = 6
	animSlots[2] = 7
	animSlots[3] = 8
	animSlots[4] = 9
	int animIndex = -1

	; use indexFound to record index

	While !stopLook

		checkAlias = DialogueFollower.GetAlias(index) as ReferenceAlias
		follower = checkAlias.GetReference() as actor
		slotNumber = index

		if myVal && (follower == myActor)
			stopLook = True
		elseif (myVal == 0) && (follower == None)
			animIndex = animSlots.Find(index)

			if IsAnimal && (animIndex > -1) ; animal
				stopLook = True
			endif
			if (IsAnimal == 0) && (animIndex < 0) ; follower
				stopLook = True
			endif
		endif

		if stopLook
			indexFound = index
			aliasFound = checkAlias
		endif

		index -= 1
		;debug.notification("searching "+index)
		stopLook = (index < 0) || (stopLook == True)
	EndWhile
	;debug.notification("ended loop")

	; retrieve slot number
	if slotNumber >= 6
		slotNumber -= 4
	elseif slotNumber == 0
		slotNumber = 1
	endif

	return aliasFound
EndFunction

; increase/decrease count, adjust sandbox
Function GetFollowerCount()

	myFCount = 0
	myACount = 0

	int index = slotsUsed ; slots index
	bool stopLook = False
	actor follower
	ReferenceAlias checkAlias

	int[] animSlots = new Int[2]
	animSlots[0] = 1
	animSlots[1] = 6
	int animIndex = -1

	While index >= 0
		checkAlias = DialogueFollower.GetAlias(index) as ReferenceAlias
		follower = checkAlias.GetReference() as actor

		if follower
			animIndex = animSlots.Find(index)
			if animIndex > -1
				; is animal
				myACount += 1
			else
				; is follower
				if (follower.IsInFaction(nwsFF_ImportFac)) && (follower.IsPlayerTeammate() == False) && (!follower.IsInFaction(CurrentFollowerFaction))
					; clean exported
					ExportFollower(follower)
					Utility.Wait(0.1)
				else
					myFCount += 1
				endif
			endif
		endif
		index -= 1
		;stopLook = (index < 0)
	EndWhile

	; follower count
	if myFCount == 5
		pPlayerFollowerCount.SetValue(1)
	else
		pPlayerFollowerCount.SetValue(0)
	endif
	nwsFollowerCount.SetValue(myFCount)

	; animal count
	if myACount == 2
		PlayerAnimalCount.SetValue(1)
	else
		PlayerAnimalCount.SetValue(0)
	endif
	nwsAnimalCount.SetValue(myFCount)

	; adjust sandbox
	if (nwsAllowSandbox.GetValue() == 1) || (nwsAllowWarp.GetValue() == 1)
		if (myFCount == 0) && (myACount == 0)
			UnregisterForUpdate()
		else
			RegisterForSingleUpdate(timerTick)
		endif
	endif

EndFunction

; FOLLOWER FRAMEWORK Settings --

; toggle sandboxing
Function ToggleSandbox()
	if nwsAllowSandbox.GetValue() == 0
		nwsAllowSandbox.SetValue(1)
		RegisterForSingleUpdate(timerTick)
	else
		nwsAllowSandbox.SetValue(0)
		UnregisterForUpdate()
	endif
EndFunction

; toggle stealth
Function ToggleStealth()
	if nwsAllowStealth.GetValue() == 0
		nwsAllowStealth.SetValue(1)
	else
		nwsAllowStealth.SetValue(0)
	endif
EndFunction

; toggle blade opt
Function ToggleBlade()
	if nwsBladeOpt.GetValue() == 0
		nwsBladeOpt.SetValue(1)
	else
		nwsBladeOpt.SetValue(0)
	endif
EndFunction

; toggle sandbox in town
Function ToggleTownBox()
	if nwsBoxOnlyCity.GetValue() == 0
		nwsBoxOnlyCity.SetValue(1)
	else
		nwsBoxOnlyCity.SetValue(0)
	endif
EndFunction

; toggle warping
Function ToggleWarping()
	if nwsAllowWarp.GetValue() == 0
		nwsAllowWarp.SetValue(1)
	else
		nwsAllowWarp.SetValue(0)
	endif
EndFunction

; toggle augment speed
Function ToggleSpeed()
	if nwsAllowSpeed.GetValue() == 0
		nwsAllowSpeed.SetValue(1)
		AugmentSpeedAll(1)
	else
		nwsAllowSpeed.SetValue(0)
		AugmentSpeedAll(0)
	endif
EndFunction

Function ToggleWpnDraw()
	if nwsWeapDraw.GetValue() == 0
		nwsWeapDraw.SetValue(1)
		Game.SetGameSettingFloat("fAIDistanceTeammateDrawWeapon", 0.0)
	else
		nwsWeapDraw.SetValue(0)
		Game.SetGameSettingFloat("fAIDistanceTeammateDrawWeapon", 2000.0)
	endif
EndFunction


; toggle combat helmet ability
Function ToggleHelm(actor myActor)
	if myActor.IsInFaction(nwsFF_HelmFac)
		myActor.RemoveFromFaction(nwsFF_HelmFac)
	else
		myActor.AddToFaction(nwsFF_HelmFac)
	endif

	if nwsTut_helmShown == False
		nwsTut_helmShown = True
		debug.messagebox("Once enabled on a follower, you must trade (or force equip) a headwear item to tell the framework which headwear to use.")
	endif

EndFunction

; toggles for Import Followers

Function ToggleBoxFac(actor myActor)
	int myRank = myActor.GetFactionRank(nwsFF_BoxFaction)
	if myRank == 1
		myActor.SetFactionRank(nwsFF_BoxFaction, 0)
	else
		myActor.SetFactionRank(nwsFF_BoxFaction, 1)
	endif
EndFunction

Function ToggleStealthFac(actor myActor)
	int myRank = myActor.GetFactionRank(nwsFF_StealthFac)
	if myRank == 1
		myActor.SetFactionRank(nwsFF_StealthFac, 0)
	else
		myActor.SetFactionRank(nwsFF_StealthFac, 1)
	endif
EndFunction

; set range for follower --
Function SetRange(actor myActor, int rngVal)
	if (!myActor.IsInFaction(nwsFF_NCRangeFac))
		myActor.AddToFaction(nwsFF_NCRangeFac)
	endif
	if rngVal == 1
		myActor.SetFactionRank(nwsFF_NCRangeFac, 1)
	elseif rngVal == 2
		myActor.SetFactionRank(nwsFF_NCRangeFac, 2)
	else
		myActor.SetFactionRank(nwsFF_NCRangeFac, 0)
	endif
	myActor.EvaluatePackage()
EndFunction

; set combat range for follower --
Function SetCbtRange(actor myActor, int rngVal)
	if (!myActor.IsInFaction(nwsFF_RangeFac))
		myActor.AddToFaction(nwsFF_RangeFac)
	endif
	if rngVal == 1
		myActor.SetFactionRank(nwsFF_RangeFac, 1)
	elseif rngVal == 2
		myActor.SetFactionRank(nwsFF_RangeFac, 2)
	else
		myActor.SetFactionRank(nwsFF_RangeFac, 0)
	endif
	myActor.EvaluatePackage()
EndFunction

; set combat role
Function SetFollowerRole(actor myActor, int myVal, int doMsg = 1)
	if !myActor.IsInFaction(nwsFF_RoleFac)
		myActor.AddToFaction(nwsFF_RoleFac)
	endif
	myActor.SetFactionRank(nwsFF_RoleFac, myVal)

	string actName = myActor.GetBaseObject().GetName()

	if myVal == 1 ; healer
		if !myActor.HasSpell(nwsHealSelf)
			myActor.AddSpell(nwsHealSelf)
		endif
		if doMsg
			debug.notification(actName + " is in the Healer Role.")
		endif
	else ; not healer
		if myActor.HasSpell(nwsHealSelf)
			myActor.RemoveSpell(nwsHealSelf)
		endif
		if doMsg
			debug.notification(actName + " is in the Default Role.")
		endif
	endif
EndFunction

; FOLLOWER FRAMEWORK Actions --

; teleport follower(s)
Function FollowerPort(actor myActor)
	if myActor.GetDistance(myPlayer) >= 512.0
		float warpDist = 192.0
		float pAngle = myPlayer.GetAngleZ() + 180.0
		float pSin = Math.sin(pAngle)
		float pCos = Math.cos(pAngle)
		myActor.MoveTo(myPlayer, warpDist * pSin, warpDist * pCos, 0.0)
	endif
EndFunction

; test function
Function AugmentSpeed(actor myActor, int myVal)

	float actSpeed = myActor.GetActorValue("SpeedMult")
	if myVal == 1
		if (actSpeed < 125.0)
			myActor.AddToFaction(nwsFF_SpeedFac) ; flag that actor was enhanced
			myActor.SetActorValue("SpeedMult", 125.0)
		endif
	else
		if myActor.IsInFaction(nwsFF_SpeedFac)
			myActor.SetActorValue("SpeedMult", 100.0)
			myActor.RemoveFromFaction(nwsFF_SpeedFac)
		endif
	endif

EndFunction

; FOLLOWER FRAMEWORK Multi-Functions --

Function DoTaskAll(int myVal, int myOpt = 0)
	int index = (slotsUsed - 1)
	int count = 6
	actor follower
	ReferenceAlias checkAlias

	; go through all filled aliases and perform task
	While (index > 0)
		checkAlias = DialogueFollower.GetAlias(index) as ReferenceAlias
		follower = checkAlias.GetReference() as actor

		if follower != None
			indexFound = index ; pass index
			; description only
			slotNumber = index
			if slotNumber >= 6
				slotNumber -= 4
			elseif slotNumber == 0
				slotNumber = 1
			endif
			; do task
			PerformTask(myVal, follower, myOpt, checkAlias)
		endif
		index -= 1
	EndWhile

	; check count on dismissal
	if myVal == 2
		GetFollowerCount()
	endif
EndFunction

; perform tasks across followers
Function PerformTask(int myVal, actor myActor, int myOpt = 0, referencealias myAlias=None)
	; task 0 removed
	if myVal == 1
		myActor.EvaluatePackage()
	elseif myVal == 2
		if indexFound == 1 || (indexFound >= 6)
			RemoveAnimal(myActor, -1)
		else
			RemoveFollower(myActor, -1, 0)
		endif
		Utility.Wait(0.2)
	elseif myVal == 3
		FollowerWaitHere(myActor)
	elseif myVal == 4
		FollowerFollowMe(myActor)
	elseif myVal == 6
		WarpCheckActor(myActor)
	elseif myVal == 7 ; defrag slots
		SortSlot(myActor)
	elseif myVal == 8
		Utility.Wait(0.2)
		FollowerPort(myActor)
	elseif myVal == 9
		AugmentSpeed(myActor, myOpt)
	elseif myVal == 10 ; follow range
		SetRange(myActor, myOpt)
	elseif myVal == 11 ; combat range
		SetCbtRange(myActor, myOpt)
	elseif myVal == 12
		FollowerWaitHere(myActor, 0, 1)
	endif
EndFunction

; Dismiss all
Function DismissAll()
	DoTaskAll(2)
	debug.notification("All Followers dismissed")
EndFunction

; Wait all
Function WaitAll()
	DoTaskAll(3)
	debug.notification("All Followers are waiting")
EndFunction

; Wait and Box All
Function WaitForever()
	DoTaskAll(12)
	debug.notification("All Followers are waiting")
EndFunction

; Follow all
Function FollowAll()
	DoTaskAll(4)
	debug.notification("All Followers are following")
EndFunction

; all follow range
Function SetRangeAll(int myOpt)
	DoTaskAll(10, myOpt)
EndFunction

; all combat range
Function SetCbtRangeAll(int myOpt)
	DoTaskAll(11, myOpt)
EndFunction

Function AugmentSpeedAll(int myOpt)
	DoTaskAll(9, myOpt)
EndFunction

; portal all to player
Function PortAll()
	DoTaskAll(8)
EndFunction

Function SortSlotsAll()
	DoTaskAll(7)
EndFunction

Function SortSlot(actor myActor)
	ReferenceAlias filledAlias = SearchAlias(myActor, 1)
	if filledAlias
		filledAlias.Clear()

		string petStr = ""

		; add to first empty
		ReferenceAlias emptyAlias
		if indexFound == 1 || (indexFound >= 6)
			emptyAlias = SearchAlias(myActor, 0, 1)
			petStr = " Pet"
		else
			emptyAlias = SearchAlias(myActor, 0)
		endif

		;ReferenceAlias emptyAlias = SearchAlias(myActor, 0)
		if emptyAlias != None
			emptyAlias.ForceRefTo(myActor)
			string actName = myActor.GetBaseObject().GetName()
			debug.notification(actName + " added to"+petStr+" Slot "+slotNumber)

			if myActor.IsInFaction(nwsFF_ComeHereFac)
				myActor.RemoveFromFaction(nwsFF_ComeHereFac)
			endif

		endif

	endif
EndFunction

; test functions
Function ImportFollower(actor myActor)

	string actName = myActor.GetBaseObject().GetName()

	; double-check to avoid dual recruit
	ReferenceAlias filledAlias = SearchAlias(myActor, 1)
	if filledAlias == None

		ReferenceAlias lookAlias = SearchAlias(myActor, 0)
		if lookAlias
			lookAlias.ForceRefTo(myActor)
			debug.notification(actName + " added to Slot "+slotNumber)

			myActor.AddToFaction(nwsFF_ImportFac)

			; add to boxing package
			ReferenceAlias packAlias = nwsFollowerPack.GetAlias(slotNumber - 1) as ReferenceAlias
			if packAlias
				packAlias.ForceRefTo(myActor)

				; sandbox faction
				if !myActor.IsInFaction(nwsFF_BoxFaction) ; initially set to 1
					myActor.AddToFaction(nwsFF_BoxFaction)
					myActor.SetFactionRank(nwsFF_BoxFaction, 1)
				endif

				; stealth faction
				if !myActor.IsInFaction(nwsFF_StealthFac) ; initially set to 1
					myActor.AddToFaction(nwsFF_StealthFac)
					myActor.SetFactionRank(nwsFF_StealthFac, 1)
				endif

			endif

			int impCount = nwsImportCount.GetValue() as int
			impCount += 1
			nwsImportCount.SetValue(impCount)

			GetFollowerCount() ; adjust follower count
			if !myActor.IsInFaction(nwsFF_RoleFac)
				SetFollowerRole(myActor, 0, 0)
			endif

			if nwsAllowSpeed.GetValue() == 1
				AugmentSpeed(myActor, 1)
			endif

			myActor.EvaluatePackage()
		else
			debug.notification("No open Slot for importing")
		endif
	else
		debug.notification(actName+" is already your follower")
	endif


EndFunction

Function ExportFollower(actor myActor)
	referenceAlias lookAlias = SearchAlias(myActor, 1)
	if lookAlias
		; remove boxer
		ReferenceAlias packAlias = nwsFollowerPack.GetAlias(slotNumber - 1) as ReferenceAlias
		if packAlias
			packAlias.Clear()
		endif

		myActor.RemoveFromFaction(nwsFF_ImportFac)

		int impCount = nwsImportCount.GetValue() as int
		impCount -= 1
		nwsImportCount.SetValue(impCount)

		; remove augment speed
		AugmentSpeed(myActor, 0)

		lookAlias.Clear()
		GetFollowerCount()
		myActor.EvaluatePackage()
		string actName = myActor.GetBaseObject().GetName()
		debug.notification(actName + " removed from framework")
	endif
EndFunction

; FOLLOWER FRAMEWORK - Single Follower Functions -- 

Function ForceEquip(actor myActor)
	nwsFFequipREF.Activate(myPlayer)
	Utility.Wait(0.1)

	int formSize = nwsFFequipForm.GetSize()
	if formSize
		; forceequip all items
		myActor.UnequipAll()
		Form outfitItem
		While formSize
			formSize -= 1
			outfitItem = nwsFFequipForm.GetAt(formSize)
			myActor.AddItem(outfitItem, 1, true)
			myActor.EquipItem(outfitItem, true, true)
		EndWhile

		nwsFFequipREF.RemoveAllItems()
		nwsFFequipForm.Revert()
	endif
EndFunction

Function ShowStats(actor myActor)
	int actLevel = myActor.GetLevel()
	int actHealth = myActor.GetActorValue("Health") as int
	int actMagicka = myActor.GetActorValue("Magicka") as int
	int actStamina = myActor.GetActorValue("Stamina") as int

	int spdMult = myActor.GetActorValue("SpeedMult") as int

	int actCarry = myActor.GetActorValue("CarryWeight") as int

	string actName = myActor.GetBaseObject().GetName()
	ActorBase actBase = myActor.GetActorBase()

	; gender
	string actGender = "It"
	if actBase.GetSex() == 0
		actGender = "He"
	elseif actBase.GetSex() == 1
		actGender = "She"
	endif

	string myMsg = ""
	myMsg += "+-- " + actName+ " --+\n\n"
	myMsg += "Level: " + actLevel + "  Health: " + actHealth + "\n"
	myMsg += "Magicka: " + actMagicka + "  Stamina: " + actStamina + "\n"
	myMsg += "Movement Spd: " + spdMult + "\n\n"

	String[] resistStr = new String[7]
	resistStr[0] = "Damage"
	resistStr[1] = "Disease"
	resistStr[2] = "Poison"
	resistStr[3] = "Fire"
	resistStr[4] = "Electric"
	resistStr[5] = "Frost"
	resistStr[6] = "Magic"

	myMsg += "Resistances: "
	int index = 0
	string resistAV
	int resistVal
	bool doComma = False
	bool hasResist = False
	
	while index < 7
		resistAV = resistStr[index]+"Resist"
		resistVal = myActor.GetActorValue(resistAV) as int
		if resistVal > 0
			if doComma
				myMsg += ", "
			endif
			myMsg += resistStr[index] + " ("+resistVal+")"
			doComma = True
			hasResist = True
		endif
		index += 1
	endwhile

	if hasResist
		myMsg += ".\n\n"
	else
		myMsg += "None.\n\n"
	endif

	float bestRank1 = 0.0
	float bestRank2 = 0.0
	float bestRank3 = 0.0
	string bestSkill1 = ""
	string bestSkill2 = ""
	string bestSkill3 = ""

	String[] actSkills = new String[18]
	actSkills[0] = "Alteration"
	actSkills[1] = "Block"
	actSkills[2] = "Conjuration"
	actSkills[3] = "Destruction"
	actSkills[4] = "HeavyArmor"
	actSkills[5] = "Illusion"
	actSkills[6] = "LightArmor"
	actSkills[7] = "Marksman"
	actSkills[8] = "OneHanded"
	actSkills[9] = "TwoHanded"
	actSkills[10] = "Restoration"
	actSkills[11] = "Sneak"
	actSkills[12] = "Alchemy"
	actSkills[13] = "Enchanting"
	actSkills[14] = "Lockpicking"
	actSkills[15] = "Pickpocket"
	actSkills[16] = "Smithing"
	actSkills[17] = "Speechcraft"

	float skillValue = 0.0
	index = 0
	while index < 18
		skillValue = myActor.GetActorValue(actSkills[index])
		if skillValue > bestRank1
			bestRank1 = skillValue
			bestSkill1 = actSkills[index]
		endif
		index += 1
	endwhile

	index = 0
	while index < 18
		skillValue = myActor.GetActorValue(actSkills[index])
		if skillValue > bestRank2 && actSkills[index] != bestSkill1
			bestRank2 = skillValue
			bestSkill2 = actSkills[index]
		endif
		index += 1
	endwhile

	index = 0
	while index < 18
		skillValue = myActor.GetActorValue(actSkills[index])
		if skillValue > bestRank3 && actSkills[index] != bestSkill1 && actSkills[index] != bestSkill2
			bestRank3 = skillValue
			bestSkill3 = actSkills[index]
		endif
		index += 1
	endwhile

	int bestRank1v = bestRank1 as int
	int bestRank2v = bestRank2 as int
	int bestRank3v = bestRank3 as int

	myMsg += "Best Skills: " + bestSkill1 + " (" + bestRank1v + "), " + bestSkill2 + " (" + bestRank2v + "), " + bestSkill3 + " (" + bestRank3v + ")" + ".\n\n"

	; miscellaneous
	if actBase.IsEssential()
		myMsg += actGender + " is Essential.\n"
	elseif actBase.IsProtected()
		myMsg += actGender + " is Protected.\n"
	else
		myMsg += actGender + " is Protected (while a Follower).\n"
	endif

	if myActor.IsInFaction(nwsFF_HelmFac)
		myMsg += actGender + " only uses Headwear in Combat.\n"
	endif

	Debug.MessageBox(myMsg)
	Utility.Wait(0.5)
EndFunction

; -- Tutorials

Function ShowTutCount()
	if nwsTut_countShown == False
		nwsTut_countShown = True
		nwsTut_countMSG.Show()
	endif
EndFunction

Function SetBladeRecruit(actor myActor)
	bladesREF.ForceRefTo(myActor) ; need to clear this if dismissing follower
	; set flag and also set gender
	int actSex = myActor.GetActorBase().GetSex()
	if actSex == 0
		nwsBladesCandidate = 1
	elseif actSex == 1
		nwsBladesCandidate = 2
	else
		nwsBladesCandidate = 3
	endif

EndFunction

Function EquipBlade(actor myActor)
	myActor.AddItem(AkaviriKatana, 1)
	myActor.AddItem(ArmorBladesBoots, 1)
	myActor.AddItem(ArmorBladesCuirass, 1)
	myActor.AddItem(ArmorBladesGauntlets, 1)
	myActor.AddItem(ArmorBladesHelmet, 1)
	myActor.AddItem(ArmorBladesShield, 1)

	string actName = myActor.GetBaseObject().GetName()
	debug.notification(actName + " has received Blades Equipment")

EndFunction

Function ToggleEssential(actor myActor)
	; 0 is none, 1 is protected
	string actName = myActor.GetBaseObject().GetName()
	ActorBase myBase = myActor.GetActorBase()
	; in Ess Faction, revert
	if myActor.IsInFaction(nwsFF_EssFac)
		int essRank = myActor.GetFactionRank(nwsFF_EssFac)
		if essRank == 0
			; restore to none
			myBase.SetEssential(False)
			myBase.SetProtected(False)
		elseif essRank == 1
			; restore to protected
			myBase.SetEssential(False)
			myBase.SetProtected(True)
		endif
		myActor.RemoveFromFaction(nwsFF_EssFac)
		debug.notification(actName + " has been restored")
	else 
		; set to protected
		myActor.AddToFaction(nwsFF_EssFac)
		if myBase.IsProtected()
			myActor.SetFactionRank(nwsFF_EssFac, 1)
		else
			myActor.SetFactionRank(nwsFF_EssFac, 0)
		endif
		myBase.SetEssential(True)
		debug.notification(actName + " is now essential")
	endif
EndFunction

Function MultiCommand(Int myChoice = 0)
	; Wait All, Follow All, Summon All, Dismiss All
	myChoice = nwsCmdAll_MSG.Show()
	if myChoice == 0 ; wait
		; submenu
		int waitChoice = 0
		waitChoice = nwsCmdWait_MSG.Show()
		if waitChoice == 0
			WaitAll()
		elseif waitChoice == 1
			WaitForever()
		else
			MultiCommand()
		; elseif waitChoice == 2
		endif

		;WaitAll()
	elseif myChoice == 1 ; follow
		FollowAll()
	elseif myChoice == 2 ; distance
		DistanceCmd()
	elseif myChoice == 3 ; summon
		PortAll()
	elseif myChoice == 4 ; dismiss all
		DismissAll()
	elseif myChoice == 5 ; follower
		FollowerCmd()
	endif
EndFunction

Function DistanceCmd(Int myChoice = 0)
	myChoice = nwsCmdDist_MSG.Show()
	if myChoice == 0 ; follow range
		int myRange = 0
		myRange = nwsCmdRange_MSG.Show()
		if myRange == 0
			SetRangeAll(1)
		elseif myRange == 1
			SetRangeAll(0)
		elseif myRange == 2
			SetRangeAll(2)
		endif
		DistanceCmd()
	elseif myChoice == 1 ; follow range
		int myRange = 0
		myRange = nwsCmdRange_MSG.Show()
		if myRange == 0
			SetCbtRangeAll(1)
		elseif myRange == 1
			SetCbtRangeAll(0)
		elseif myRange == 2
			SetCbtRangeAll(2)
		endif
		DistanceCmd()
	elseif myChoice == 2
		MultiCommand()
	endif
EndFunction

Function FollowerCmd(Int myChoice = 0)
	bool msgStop = False
	;ReferenceAlias myRef
	;Actor follower

	Int[] myOrder = new Int[10]
	; fill order array
	myOrder[0] = 5
	myOrder[1] = 4
	myOrder[2] = 3
	myOrder[3] = 2
	myOrder[4] = 0
	myOrder[5] = 9
	myOrder[6] = 8
	myOrder[7] = 7
	myOrder[8] = 6
	myOrder[9] = 1

	Actor[] myActor = new Actor[10]
	; fill actor array
	int count = 0 ; where actor slot starts
	bool doCount = False
	actor follower
	ReferenceAlias checkAlias
	int index = 0

	While (index < 10)
		checkAlias = DialogueFollower.GetAlias(myOrder[index]) as ReferenceAlias
		follower = checkAlias.GetReference() as actor
		if follower
			myActor[index] = follower
			if !doCount
				doCount = True
				count = index
			endif
		endif
		index += 1
	EndWhile

	Message lookMenu
	Actor lookActor

	While !msgStop

		lookActor = myActor[count]
		speakerREF.ForceRefTo(lookActor)
		Utility.Wait(0.1)
		myChoice = nwsCmdOne_MSG.Show()

		if myChoice == 0
			bool doChoice = False
			While !doChoice
				count -= 1
				if count < 0
					count = (slotsUsed - 1)
				endif
				if myActor[count]
					doChoice = True
				endif
			EndWhile
		elseif myChoice == 1
			; submenu
			int waitChoice = 0
			waitChoice = nwsCmdWait_MSG.Show()
			if waitChoice == 0
				FollowerWaitHere(lookActor, 1, 0)
				msgStop = True
			elseif waitChoice == 1
				FollowerWaitHere(lookActor, 1, 1)
				msgStop = True
			endif
		elseif myChoice == 2 ; follow
			FollowerFollowMe(lookActor, 1)
			msgStop = True
		elseif myChoice == 3 ; summon
			FollowerPort(lookActor)
			msgStop = True
		elseif myChoice == 4 ; dismiss
			if myOrder[count] == 1 || (myOrder[count] >= 6)
				RemoveAnimal(lookActor, 1)
			else
				RemoveFollower(lookActor, 0, 1)
			endif
			msgStop = True
		elseif myChoice == 5
			bool doChoice = False
			While !doChoice
				count += 1
				if count > (slotsUsed - 1)
					count = 0
				endif
				if myActor[count]
					doChoice = True
				endif
			EndWhile
		elseif myChoice == 6
			msgStop = True
		endif
	EndWhile
EndFunction
